import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the colors
clear_color = "green"
occupied_color = "blue"
painted_color = "red"
robot1_color = "white"
robot2_color = "black"

# Define the grid size
rows, cols = 5, 4

# Plot the tiles
for i in range(rows):
    for j in range(cols):
        # Determine the color of the tile
        if (i == 1 and j == 0) or (i == 1 and j == 1):
            tile_color = occupied_color
        else:
            tile_color = clear_color
        
        # Create a rectangle for the tile
        tile = patches.Rectangle((j, rows - i - 1), 1, 1, edgecolor='black', facecolor=tile_color)
        ax.add_patch(tile)
        # Add text label
        ax.text(j + 0.5, rows - i - 0.5, f'tile_{i}-{j+1}', color='black', ha='center', va='center', fontsize=8)

# Plot the robots
robot1 = patches.Circle((0.5, rows - 1 - 0.5), 0.3, color=robot1_color, ec='black')
ax.add_patch(robot1)
ax.text(0.5, rows - 1 - 0.5, 'robot1\nwhite', color='black', ha='center', va='center', fontsize=8)

robot2 = patches.Circle((1.5, rows - 1 - 0.5), 0.3, color=robot2_color, ec='black')
ax.add_patch(robot2)
ax.text(1.5, rows - 1 - 0.5, 'robot2\nblack', color='white', ha='center', va='center', fontsize=8)

# Plot available colors
color_white = patches.Rectangle((5, 4), 0.5, 0.5, color='white', ec='black')
ax.add_patch(color_white)
ax.text(5.25, 4.25, 'white', color='black', ha='center', va='center', fontsize=8)

color_black = patches.Rectangle((5, 3), 0.5, 0.5, color='black', ec='black')
ax.add_patch(color_black)
ax.text(5.25, 3.25, 'black', color='white', ha='center', va='center', fontsize=8)

# Create legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=occupied_color, edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor=painted_color, edgecolor='black', label='Painted Tile'),
    patches.Patch(facecolor='white', edgecolor='black', label='Robot Holding White'),
    patches.Patch(facecolor='black', edgecolor='black', label='Robot Holding Black')
]
ax.legend(handles=legend_elements, loc='upper center', bbox_to_anchor=(0.5, -0.05), fontsize=8, ncol=2)

# Set limits, aspect, and remove axes
ax.set_xlim(-0.5, cols)
ax.set_ylim(-0.5, rows)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_32.png', bbox_inches='tight')
plt.show()